#-------------------------------------------------------------------
#  AuthMgr.py
#
#  The AuthMgr class.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the AuthMgr class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
from werkzeug.wrappers import Request
from werkzeug.wrappers import Response
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class AuthMgr:
  '''Manages authentication and authorization for the web application.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new AuthMgr.
    '''

    pass

  #-----------------------------------------------------------------
  def userInfo(self) -> object:
    '''Returns the UserInfo object for the current session.

    @return A UserInfo object, or None if the user is not logged in.
    '''

    raise NotImplementedError()

  #----------------------------------------------------------------
  def userName(self) -> str:
    '''Returns the string user name for the current session.

    @return A string name.  This never returns None.
    '''

    raise NotImplementedError()

  #----------------------------------------------------------------
  def loggedInRequired(self, path: str) -> bool:
    '''Returns True if the user must be logged in to see the specified path.

    @param path The string path that the user wishes to see, such as
                farm/read or user/login.

    @return True if the user must be logged in to view the specified path,
            False if a non-logged in user is allowed to view the path.
    '''

    raise NotImplementedError()

  #----------------------------------------------------------------
  def notAuthenticatedResponse(self, request: Request) -> Response:
    '''Returns the response to be made to un-authenticated users.

    @param request The user's HTTP request.  A Werkzeug Request object.

    @return A Werkzeug Response object to be returned to the browser.
    '''

    raise NotImplementedError()

  #----------------------------------------------------------------
  def readHttpSession(self, request: Request) -> None:
    '''Reads the HTTP session from the request headers.

    If database access is needed to read the HTTP session,
    this method will create its own DB session and clean it up
    before returning.

    @param request The HTTP request.  A werkzeug Request object.
    '''

    raise NotImplementedError()

  #----------------------------------------------------------------
  def writeHttpSession(self, response: Response) -> None:
    '''Writes the HTTP session to the response headers.

    @param request The HTTP response.  A werkzeug Response object.
    '''

    raise NotImplementedError()

  #----------------------------------------------------------------
  def __repr__(self):
    '''Returns a string representation of this object
    '''
    attrs = []

    return StringUtil.formatRepr(self, attrs)
