#-------------------------------------------------------------------
#  TestReflectionUtil.py
#
#  The TestReflectionUtil module.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Unit test for the ReflectionUtil class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import ReflectionUtil
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestReflectionUtil(AxeSimpleTestCase):
  '''Unit test for the ReflectionUtil class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCopyDocstrings(self) -> None:
    '''Test copying docstrings.
    '''

    class SrcClass:

      srcVariable = 3

      def __init__(self) -> None:
        pass

      def srcFunction1(self) -> None:
        '''The srcFunction1 in the SrcClass.'''

        pass

      def srcFunction2(self) -> None:
        '''The srcFunction2 in the SrcClass.'''

        pass

      def srcFunctionNoDoc(self) -> None:
        pass

    class DestClass:

      def __init__(self) -> None:
        pass

      def srcVariable(self) -> None:
        '''The srcVariable in the DestClass.'''

        pass

      def srcFunction1(self) -> None:
        pass

      def srcFunction2(self) -> None:
        '''The srcFunction2 in the DestClass.'''
        pass

      def srcFunctionNoDoc(self) -> None:
        pass

      ReflectionUtil.copyDocstrings(SrcClass, locals())

    self.assertEqual('The srcVariable in the DestClass.',
                     DestClass.srcVariable.__doc__,
                     'Method that shadows a variable is ignored.')
    self.assertEqual('The srcFunction1 in the SrcClass.',
                     DestClass.srcFunction1.__doc__,
                     'Function with no doc gets one added.')
    self.assertEqual('The srcFunction2 in the DestClass.',
                     DestClass.srcFunction2.__doc__,
                     'Function with a doc is not disturbed.')
    self.assertEqual(None,
                     DestClass.srcFunctionNoDoc.__doc__,
                     'Function without a doc remains without a doc.')
