#-------------------------------------------------------------------
#  TestArrayUtil.py
#
#  The TestArrayUtil module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the ArrayUtil class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeSimpleTestCase
from ai.axe.util import ArrayUtil
from typing import List
from typing import Optional
from typing import Union
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestArrayUtil(AxeSimpleTestCase):
  '''Unit test for the ArrayUtil class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testMultiply(self) -> None:
    '''Test the multiply() method.
    '''

    array2d = [[1, 2], [3, 4], [None, 0]]
    expected = [[2, 4], [6, 8], [None, 0]]

    actual = ArrayUtil.multiply(array2d, 2)

    self.assertEqual(expected, actual, "multiply")

    array2d = []
    expected = []
    actual = ArrayUtil.multiply(array2d, 2)

    self.assertEqual(expected, actual, "empty")

  #-----------------------------------------------------------------
  def testCall(self) -> None:
    '''Test the call() method.
    '''

    def doubleAndOne(value: Union[int, None]) -> int:
      if value is None:
        return 777
      return value * 2 + 1

    array2d = [[1, 2], [3, 4], [None, 0]]
    expected = [[3, 5], [7, 9], [777, 1]]

    actual = ArrayUtil.call(array2d, doubleAndOne)

    self.assertEqual(expected, actual, "call, processed None")

    expected2 = [[3, 5], [7, 9], [None, 1]]
    actual = ArrayUtil.call(array2d, doubleAndOne, rawNones=True)

    self.assertEqual(expected2, actual, "call, unprocessed None")

    array2d = []
    expected = []
    actual = ArrayUtil.call(array2d, doubleAndOne)

    self.assertEqual(expected, actual, "empty")

  #-----------------------------------------------------------------
  def testGrow(self) -> None:
    '''Test the grow() method.
    '''

    array2d: List[List[Optional[float]]] = [[1, 2],
                                            [3, 4],
                                            [None, 0]]

    expected = [[1, 1, 1, 2, 2, 2],
                [1, 1, 1, 2, 2, 2],
                [1, 1, 1, 2, 2, 2],
                [3, 3, 3, 4, 4, 4],
                [3, 3, 3, 4, 4, 4],
                [3, 3, 3, 4, 4, 4],
                [None, None, None, 0, 0, 0],
                [None, None, None, 0, 0, 0],
                [None, None, None, 0, 0, 0]]

    actual = ArrayUtil.grow(array2d, 3)

    self.assertEqual(expected, actual, "grow 3")

  #-----------------------------------------------------------------
  def testShrink(self) -> None:
    '''Test the shrink() method.
    '''

    array2d: List[List[Optional[float]]] = [[1, 1, 1, 2, 2, 2],
                                            [1, 1, 1, 2, 2, 2],
                                            [1, 1, 1, 2, 2, 2],
                                            [3, 3, 3, 4, 4, 4],
                                            [3, 3, 3, 4, 4, 4],
                                            [3, 3, 3, 4, 4, 4],
                                            [None, None, None, 0, 0, 0],
                                            [None, None, None, 0, 0, 0],
                                            [None, None, None, 0, 0, 0]]

    expected = [[1, 2],
                [3, 4],
                [None, 0]]

    actual = ArrayUtil.shrink(array2d, 3)

    self.assertEqual(expected, actual, "shrink 3")

    # Shrink with Nones at the edges.

    array2d = [[1, 2, 1, 2, 2, None],
               [3, 2, 3, 2, 5.5, None],
               [1, 3, 2, 2, 2, 2],

               [3, 3, 3, 4, 4, 4],
               [None, 3, 3, 4, 4, None],
               [None, 3, 3, 4, 4, 4],

               [None, None, None, 0, 0, 0],
               [None, None, None, 0, 0, 0],
               [None, None, None, 0, 0, 0]]

    expected = [[2, 2.5],
                [3, 4],
                [None, 0]]

    actual = ArrayUtil.shrink(array2d, 3)

    self.assertEqual(expected, actual, "shrink ragged")

    # Shrink by 3, but array size is not an even multiple of 3.

    array2d = [[1, 1, 1, 1, 3,],
               [1, 1, 1, 1, 3,],
               [1, 1, 1, 1, 3,],
               [3, 3, 3, 3, 5,],
               [3, 3, 3, 3, 5,],
               [3, 3, 3, 3, 5,],
               [1, 2, 3, 4, 5,]]

    expected = [[1, 2],
                [3, 4],
                [2, 4.5]]

    actual = ArrayUtil.shrink(array2d, 3)

    self.assertEqual(expected, actual, "shrink non-even sides")

  #-----------------------------------------------------------------
  def testStr(self) -> None:
    '''Test the toStr() method.
    '''

    array2d: List[List[object]] = [[1, 2],
                                   [3, 4],
                                   [None, 0]]

    expected = '''[[1, 2],
[3, 4],
[None, 0]]'''

    actual = ArrayUtil.toStr(array2d)

    self.assertEqual(expected, actual, "toStr")
