#-------------------------------------------------------------------
#  ReflectionUtil.py
#
#  The ReflectionUtil module.
#
#  Copyright 2013 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Run-time reflection utilities.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import Any
from typing import Dict
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def copyDocstrings(fromClass: type, toAttrDict: Dict[str, Any]) -> None:
  '''Copies docstrings from all functions from 'fromClass' to 'toAttrDict'.

  @param fromClass Docstrings form all methods in this class will be copied.
  @param toAttrDict The docstrings will be added to methods in this dict.
  '''

  for funcName, func in list(toAttrDict.items()):

    # If it's not a method, ignore it.
    if not hasattr(func, '__call__') or func.__name__ != funcName:
      continue

    elif not func.__doc__ and hasattr(fromClass, funcName):
      func.__doc__ = getattr(fromClass, funcName).__doc__
