#-------------------------------------------------------------------
#  IdName.py
#
#  The IdName class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the IdName class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonField
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@ClassJsonClass([ClassJsonField('id', int),
                 ClassJsonField('name', str)])
class IdName:
  '''A short description of something, just a name and ID.
  '''

  #-----------------------------------------------------------------
  def __init__(self, id: int, name: str) -> None:
    '''Creates a new IdName.
    '''

    self.id = id
    self.name = name

  #-----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object.
    '''

    ret = 'IdName(id=' + str(self.id) + ', name=' + str(self.name) + ')'
    return ret
