#-------------------------------------------------------------------
#  HttpUtil.py
#
#  The HttpUtil module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''HTTP utility functions.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
import base64
from urllib.request import Request
from werkzeug.wrappers import Response
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def addBasicAuthHeader(request: Request, name: str, password: str) -> None:
  '''Adds a Basic HTTP authentication header to a urllib Request.'''

  valueStr = '%s:%s' % (name, password)
  valueStr = valueStr.replace('\n', '')

  base64bytes: bytes = base64.encodebytes(valueStr.encode('UTF-8'))
  base64string: str = base64bytes.decode('UTF-8')

  request.add_header("Authorization", "Basic %s" % base64string)

#-------------------------------------------------------------------
def addNoCacheHeader(response: Response) -> None:
  '''Adds headers to make an HTTP response page no-cache.

  @param response The HTTP response.
  '''

  # Set standard HTTP/1.1 no-cache headers.
  response.headers.add("Cache-Control", "no-store, no-cache, must-revalidate")

  # Set IE extended HTTP/1.1 no-cache headers (use addHeader).
  response.headers.add("Cache-Control", "post-check=0, pre-check=0")

  # We used to set the standard HTTP/1.0 no-cache header like so:
  #
  #  response.setHeader("Pragma", "no-cache");
  #
  # However, if this header is used on an HTTPS download, IE 8 will
  # refuse to download the file.
  #
  # Since we're only supporting modern browsers, we shouldn't need
  # this old header any more.
