#-------------------------------------------------------------------
#  TestRectangle.py
#
#  The TestRectangle module.
#
#  Copyright 2019 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the Rectangle class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeSimpleTestCase
from ai.axe.math import Rectangle
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestRectangle(AxeSimpleTestCase):
  '''Unit test for the Rectangle class.
  '''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating a Rectangle.
    '''

    rect = Rectangle(10, 20, 3, 4)
    self.assertRect(rect, 10, 20, 3, 4, 'ctor')

    self.assertEqual(((13, 24), (10, 20)),
                     rect.toPostgresPoints(),
                     'toPostgresPoints')

    rect = Rectangle.fromPostgresPoints((13, 24), (10, 20))
    self.assertRect(rect, 10, 20, 3, 4, 'postgres points')

    self.assertEqual(hash((10, 20, 3, 4)), hash(rect), 'hash')

    rect2 = Rectangle(10, 20, 3, 4)
    rect3 = Rectangle(10, 20, 3, 44)

    self.assertFalse(rect == 3)

    self.assertTrue(rect == rect2)
    self.assertFalse(rect != rect2)
    self.assertFalse(rect == rect3)
    self.assertTrue(rect != rect3)

    # Check that repr doesn't throw an exception and get coverage up.
    str(rect)

  #-----------------------------------------------------------------
  def assertRect(self,
                 rect: Rectangle,
                 x: float,
                 y: float,
                 width: float,
                 height: float,
                 msg: str) -> None:
    '''Private helper function to check a rect's coordinates.
    '''

    self.assertEqual(x, rect.x, msg + ': x')
    self.assertEqual(y, rect.y, msg + ': y')
    self.assertEqual(width, rect.width, msg + ': width')
    self.assertEqual(height, rect.height, msg + ': height')
