#-------------------------------------------------------------------
#  TestBase64.py
#
#  The TestBase64 module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the Base64 class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.js.jsSourceMap import SourceMapException
from ai.axe.js.jsSourceMap import Base64
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestBase64(AxeSimpleTestCase):
  '''Unit test for the Base64 class.
'''

  #-----------------------------------------------------------------
  def setUp(self):

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self):

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testOutOfRangeEncoding(self):
    '''Tests out of range encoding.
    '''

    try:
      Base64.encode(-1)
      self.fail("Failed to throw Exception.")
    except SourceMapException:
      pass

    try:
      Base64.encode(64)
      self.fail("Failed to throw Exception.")
    except SourceMapException:
      pass


  #-----------------------------------------------------------------
  def testOutOfRangeDecoding(self):
    '''Tests out of range decoding.
    '''

    try:
      Base64.decode('=')
      self.fail("Failed to throw Exception.")
    except SourceMapException:
      pass

  #-----------------------------------------------------------------
  def testRoundTrip(self):
    '''Tests round trip encoding and decoding.
    '''

    for i in range(64):
      self.assertEqual(i, Base64.decode(Base64.encode(i)))
