#-------------------------------------------------------------------
#  sampleData.py
#
#  The sampleData module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Sample data for this unit test.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.js.jsSourceMap import LineColumn
from ai.axe.js.jsSourceMap import SourceLineColumn
import os
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------

# This is a test mapping which maps functions from two different files
# (one.js and two.js) to a minified generated source.
#
# Here is one.js:
#
#   ONE.foo = function (bar) {
#     return baz(bar);
#   };
#
# Here is two.js:
#
#   TWO.inc = function (n) {
#     return n + 1;
#   };
#
# And here is the generated code (min.js):
#
#   ONE.foo=function(a){return baz(a);};
#   TWO.inc=function(a){return a+1;};

#-----------------------------------------------------------------
generatedCode = (" ONE.foo=function(a){return baz(a);};\n" +
                 " TWO.inc=function(a){return a+1;};")

#-----------------------------------------------------------------
mapData = {
  'version': 3,
  'file': 'min.js',
  'names': ['bar', 'baz', 'n'],
  'sources': ['one.js', 'two.js'],
  'sourceRoot': '/the/root',
  'mappings': ('CAAC,IAAI,IAAM,SAAUA,GAClB,OAAOC,IAAID;CCDb,IAAI,IAAM,' +
              'SAAUE,GAClB,OAAOA')
}

#-----------------------------------------------------------------
mapWithSourcesContent = {
  'version': 3,
  'file': 'min.js',
  'names': ['bar', 'baz', 'n'],
  'sources': ['one.js', 'two.js'],
  'sourcesContent': [
    ' ONE.foo = function (bar) {\n' +
    '   return baz(bar);\n' +
    ' };',
    ' TWO.inc = function (n) {\n' +
    '   return n + 1;\n' +
    ' };'
  ],
  'sourceRoot': '/the/root',
  'mappings': ('CAAC,IAAI,IAAM,SAAUA,GAClB,OAAOC,IAAID;CCDb,IAAI,IAAM,' +
              'SAAUE,GAClB,OAAOA')
}

#-----------------------------------------------------------------
emptyMap = {
  'version': 3,
  'file': 'min.js',
  'names': [],
  'sources': [],
  'mappings': ''
}

#-----------------------------------------------------------------
def assertEqualMaps(self, actualMap, expectedMap):

  self.assertEqual(actualMap['version'], expectedMap['version'],
                   "version mismatch")
  self.assertEqual(actualMap['file'], expectedMap['file'], "file mismatch")
  self.assertEqual(len(actualMap['names']), len(expectedMap['names']),
                   "names length mismatch: " +
                   ', '.join(actualMap['names']) + " != " +
                   ', '.join(expectedMap['names']))
  for i in range(len(actualMap['names'])):
    self.assertEqual(actualMap['names'][i],
                 expectedMap['names'][i],
                 "names[" + str(i) + "] mismatch: " +
                   ', '.join(actualMap['names']) + " != " +
                   ', '.join(expectedMap['names']))

  self.assertEqual(len(actualMap['sources']),
                   len(expectedMap['sources']),
                   "sources length mismatch: " +
                   ', '.join(actualMap['sources']) + " != " +
                   ', '.join(expectedMap['sources']))
  for i in range(len(actualMap['sources'])):
    self.assertEqual(actualMap['sources'][i],
                 expectedMap['sources'][i],
                 "sources[" + str(i) + "] length mismatch: " +
                   ', '.join(actualMap['sources']) + " != " +
                   ', '.join(expectedMap['sources']))
  self.assertEqual(actualMap.get('sourceRoot', None),
                   expectedMap.get('sourceRoot', None),
                   "sourceRoot mismatch")
  self.assertEqual(actualMap['mappings'], expectedMap['mappings'],
                   "mappings mismatch:\nActual:   " + actualMap['mappings'] +
                   "\nExpected: " + expectedMap['mappings'])
  if 'sourcesContent' in actualMap:
    self.assertEqual(len(actualMap['sourcesContent']),
                     len(expectedMap['sourcesContent']),
                     "sourcesContent length mismatch")
    for i in range(len(actualMap['sourcesContent'])):
      self.assertEqual(actualMap['sourcesContent'][i],
                   expectedMap['sourcesContent'][i],
                   "sourcesContent[" + str(i) + "] mismatch")

#-----------------------------------------------------------------
def assertMapping(self, generatedLine, generatedColumn, originalSource,
                  originalLine, originalColumn, name, theMap,
                  dontTestGenerated=False, dontTestOriginal=False):

  if not dontTestOriginal:
    origMapping = theMap.originalPositionFor(LineColumn(generatedLine,
                                                     generatedColumn))
    self.assertEqual(origMapping.name, name, 'name')
    self.assertEqual(origMapping.line, originalLine, 'line')
    self.assertEqual(origMapping.column, originalColumn, 'column')

    if (originalSource and
        theMap.sourceRoot and
        originalSource.startswith(theMap.sourceRoot)):
      expectedSource = originalSource
    elif originalSource:
      expectedSource = originalSource
      if theMap.sourceRoot:
        expectedSource = os.path.join(theMap.sourceRoot, originalSource)
    else:
      expectedSource = None

    self.assertEqual(origMapping.source, expectedSource, 'source')

  if not dontTestGenerated:
    genMapping = theMap.generatedPositionFor(SourceLineColumn(originalSource,
                                                              originalLine,
                                                              originalColumn))
    self.assertEqual(genMapping.line, generatedLine, 'line')
    self.assertEqual(genMapping.column, generatedColumn, 'column')
