#-------------------------------------------------------------------
#  base64.py
#
#  The base64 module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Base 64 functions.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .SourceMapException import SourceMapException
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
charToIntMap = {}

#-------------------------------------------------------------------
intToCharMap = {}

#-------------------------------------------------------------------
def initMaps():
  '''Initialize the maps.
  '''

  chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
  for index, ch in enumerate(chars):
    charToIntMap[ch] = index
    intToCharMap[index] = ch

initMaps()

#-------------------------------------------------------------------
def encode(aNumber):
  '''Encode an integer in the range of 0 to 63 to a single base 64 digit.
  '''

  if aNumber in intToCharMap:
    return intToCharMap[aNumber]
  else:
    raise SourceMapException("Must be between 0 and 63: " + str(aNumber))

#-------------------------------------------------------------------
def decode(aChar):
  '''Decode a single base 64 digit to an integer.
  '''

  if aChar in charToIntMap:
    return charToIntMap[aChar]
  else:
    raise SourceMapException("Not a valid base 64 digit: " + aChar)
