#-------------------------------------------------------------------
#  TestNumberBinMap.py
#
#  The TestNumberBinMap module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the NumberBinMap class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.db.postgis import NumberBinMap
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestNumberBinMap(AxeSimpleTestCase):
  '''Unit test for the NumberBinMap class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCreation(self) -> None:
    '''Test creating a number map.
    '''

    theMap = NumberBinMap(-1, 1)

    theMap.addBin(3, True, 2)
    theMap.addBin(7, False, 3)
    theMap.addBin(10, True, 4)

    # Exception if attempt to add lower value.
    try:
      theMap.addBin(9, True, 5)
      self.fail("No exception for lower value")
    except ValueError:
      pass

    self.assertEqual(-1, theMap.noDataNumber, "noDataNumber")

    expected = [1, 2, 3, 4]
    self.assertEqual(expected, theMap.numbers, "numbers")

    expected = [3, 7, 10]
    self.assertEqual(expected, theMap.borders, "borders")

    expected = [True, False, True]
    self.assertEqual(expected, theMap.borderGoesHighs, "borderGoesHighs")

    # Make sure no exception is thrown.
    str(theMap)

  #-----------------------------------------------------------------
  def testNumberForValue(self) -> None:
    '''Test converting values to numbers.
    '''

    theMap = NumberBinMap(-1, 1)

    theMap.addBin(3, True, 2)
    theMap.addBin(7, False, 3)
    theMap.addBin(10, True, 4)

    self.assertEqual(-1, theMap.numberForValue(None), "nodata")

    self.assertEqual(1, theMap.numberForValue(2), "lowest")
    self.assertEqual(2, theMap.numberForValue(3), "bin goes up")
    self.assertEqual(2, theMap.numberForValue(7), "bin goes down")
    self.assertEqual(3, theMap.numberForValue(7.01), "middle")
    self.assertEqual(4, theMap.numberForValue(10), "highest equal")
    self.assertEqual(4, theMap.numberForValue(10.01), "highest")

  #-----------------------------------------------------------------
  def testBinSql(self) -> None:
    '''Test generating bin SQL.
    '''

    theMap = NumberBinMap(-1, 1)

    theMap.addBin(3, True, 2)
    theMap.addBin(7, False, 3)
    theMap.addBin(10, True, 6)
    theMap.addBin(12, True, 7)

    expected = (
      'case ' +
      'when [rast.val] < 3 then 1 ' +
      'when [rast.val] >= 3 and [rast.val] <= 7 then 2 ' +
      'when [rast.val] > 7 and [rast.val] < 10 then 3 ' +
      'when [rast.val] >= 10 and [rast.val] < 12 then 6 ' +
      'when [rast.val] >= 12 then 7 ' +
      'end'
    )

    self.assertEqual(expected, theMap.getBinSql(), "binSql")
