#-------------------------------------------------------------------
#  RectangleType.py
#
#  The RectangleType class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the RectangleType class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.math import Rectangle
from sqlalchemy.types import UserDefinedType
#
# Import statements go above this line.
#-------------------------------------------------------------------

# pylint: disable = C0103, super-init-not-called

#===================================================================
class RectangleType(UserDefinedType):
  '''An angle stored as a number of degrees 0 <= theta < 360.
  '''

  #-----------------------------------------------------------------
  def __init__(self):
    '''Creates a new RectangleType.
    '''

    pass

  #-----------------------------------------------------------------
  @property
  def python_type(self):
    return Rectangle

  #-----------------------------------------------------------------
  def get_col_spec(self):
    return 'box'

  #-----------------------------------------------------------------
  def result_processor(self, dialect, coltype):
    '''Returns the processor function to use to convert from SQL to Python.
    '''

    return RectangleType.floatListToObject

  #-----------------------------------------------------------------
  @staticmethod
  def floatListToObject(value):
    '''Processes a selected DB value into an Rectangle object.
    '''

    if value is None:
      return None

    assert isinstance(value, str)

    # Parse a string like '(3,4),(1,2)' into tuples of floats.
    # Could use a RE, but floating-point regex is a little ugly,
    # so use good old string.index() and string.split().

    assert value.startswith('('), value
    assert value.endswith(')'), value
    assert '),(' in value, value

    divIndex = value.index('),(')
    upperRightStr = value[1:divIndex]
    lowerLeftStr = value[divIndex + 3:-1]

    assert ',' in upperRightStr
    assert ',' in lowerLeftStr

    upperRightStrs = upperRightStr.split(',')
    lowerLeftStrs = lowerLeftStr.split(',')

    assert len(upperRightStrs) == 2, upperRightStrs
    assert len(lowerLeftStrs) == 2, lowerLeftStrs

    upperRight = float(upperRightStrs[0]), float(upperRightStrs[1])
    lowerLeft = float(lowerLeftStrs[0]), float(lowerLeftStrs[1])

    return Rectangle.fromPostgresPoints(upperRight, lowerLeft)

  #-----------------------------------------------------------------
  def bind_processor(self, dialect):
    '''Returns the processor function to use to convert from Python to SQL.
    '''

    return RectangleType.objectToFloatList

  #-----------------------------------------------------------------
  @staticmethod
  def objectToFloatList(rectangle):

    if not isinstance(rectangle, Rectangle):
      msg = "Expected axe.math.Rectangle, got: " + str(rectangle.__class__)
      raise TypeError(msg)

    else:
      return "%s %s" % rectangle.toPostgresPoints()
