#-------------------------------------------------------------------
#  AngleType.py
#
#  The AngleType class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the AngleType class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.math import Angle
from sqlalchemy.types import UserDefinedType
#
# Import statements go above this line.
#-------------------------------------------------------------------

# pylint: disable = C0103, super-init-not-called

#===================================================================
class AngleType(UserDefinedType):
  '''An angle stored as a number of degrees 0 <= theta < 360.
  '''

  #-----------------------------------------------------------------
  def __init__(self):
    '''Creates a new AngleType.
    '''

    pass

  #-----------------------------------------------------------------
  @property
  def python_type(self):
    return Angle

  #-----------------------------------------------------------------
  def get_col_spec(self):
    return 'float'

  #-----------------------------------------------------------------
  def result_processor(self, dialect, coltype):
    '''Returns the processor function to use to convert from SQL to Python.
    '''

    return AngleType.floatToObject

  #-----------------------------------------------------------------
  @staticmethod
  def floatToObject(value):
    '''Processes a selected DB value into an Angle object.
    '''

    if value is None:
      return None

    return Angle.fromDegrees(value)

  #-----------------------------------------------------------------
  def bind_processor(self, dialect):
    '''Returns the processor function to use to convert from Python to SQL.
    '''

    return AngleType.objectToFloat

  #-----------------------------------------------------------------
  @staticmethod
  def objectToFloat(angle):

    if not isinstance(angle, Angle):
      msg = "Expected axe.math.Angle, got: " + str(angle.__class__)
      raise TypeError(msg)

    else:
      return "%s" % angle.degrees

  #-----------------------------------------------------------------
  @staticmethod
  def createConstraintSql(tableName, columnName):

    sql = ("alter table %s add constraint ck_%s_%s " +
           "check(0 <= %s and %s < 360)")
    sql = sql % (tableName, tableName, columnName,
                 columnName, columnName)

    return sql
