#-------------------------------------------------------------------
#  orm.py
#
#  The orm module.
#
#  Copyright 2013 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Overrides for the sqlalchemy.orm module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .DbDict import DbDict
from .DbList import DbList
from sqlalchemy.orm.relationships import RelationshipProperty
from typing import Any
import sqlalchemy.orm
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
# Supress unused import, as we want DbList in the orm package.
Unused: Any = DbDict
Unused = DbList

#-------------------------------------------------------------------
def relationship(*args, **kwargs) -> RelationshipProperty:
  '''Creates a new relationship..

  This wraps sqlalchemy.orm.relationship(), making
  'all, delete-orphan' default value for 'cascade'.

  All arguments are passed through to sqlalchemy.orm.relationship().

  @return A new relationship.
  '''

  # Cascade everything by default.
  kwargs.setdefault('cascade', 'all, delete-orphan')

  return sqlalchemy.orm.relationship(*args, **kwargs)
