#-------------------------------------------------------------------
#  DbConfig.py
#
#  The DbConfig class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the DbConfig class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#

#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class DbConfig:
  '''Database configuration.
  '''

  #-----------------------------------------------------------------
  def __init__(self,
               url: str,
               remoteUnitTests: bool,
               poolSize: int,
               poolOverflow: int,
               poolRecycle: int,
               poolTimeout: int) -> None:
    '''Creates a new DbConfig.
    '''

    # The URL of the database to connect to.
    self.url: str = url

    # Whether unit tests can be run on a remote box, or are always localhost.
    self.remoteUnitTests: bool = remoteUnitTests

    # The number of connections allowed permanently in the pool.
    self.poolSize: int = poolSize

    # The number of connections allowed temporarily above poolSize.
    self.poolOverflow: int = poolOverflow

    # Number of seconds after which a connection will be killed.
    # Setting to -1 means never.
    self.poolRecycle: int = poolRecycle

    # How long a request will wait for a connection before giving up.
    self.poolTimeout: int = poolTimeout
