#-------------------------------------------------------------------
#  TestClassJsonField.py
#
#  The TestClassJsonField module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the ClassJsonField class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonField
from ai.axe.classJson.jsonTypes.JsonPrimitiveType import JsonPrimitiveType
import unittest
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestClassJsonField(unittest.TestCase):
  '''Unit test for the ClassJsonField class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creation.
    '''

    field = ClassJsonField('name', int).toDesc()

    self.assertTrue(isinstance(field.jsonType, JsonPrimitiveType))
    assert isinstance(field.jsonType, JsonPrimitiveType)
    jsonPrimitiveType: JsonPrimitiveType = field.jsonType

    self.assertEqual('name', field.name, 'name')
    self.assertEqual(int, jsonPrimitiveType.typeClass, 'type')

  #-----------------------------------------------------------------
  def testStr(self) -> None:
    '''Convert to string.
    '''

    str(ClassJsonField('name', int))
