#-------------------------------------------------------------------
#  TestJsonTypeError.py
#
#  The TestJsonTypeError module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the JsonTypeError class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson.jsonTypes import JsonTypeError
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestJsonTypeError(AxeSimpleTestCase):
  '''Unit test for the JsonTypeError class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCreate(self) -> None:
    '''Test creating an error.
    '''

    err = JsonTypeError('message')

    err.prependPath('f')
    err.prependPath('e')
    err.prependPath('d')
    err.prependPathKey('foo')
    err.prependPath('c')
    err.prependPathIndex(3)
    err.prependPath('b')
    err.prependPath('a')

    self.assertEqual('message', err.message, 'message')
    self.assertEqual('a/b[3]/c[foo]/d/e/f', err.path, 'path')

    self.assertIsNotNone(err.format())
    self.assertIsNotNone(str(err))
