#-------------------------------------------------------------------
#  TestJsonTypeCreation.py
#
#  The TestJsonTypeCreation module.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Unit test for the JsonTypeCreation class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from datetime import date
from datetime import datetime
from datetime import timedelta
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonException
from ai.axe.classJson import ClassJsonField
from ai.axe.classJson.jsonTypes.JsonObjRegistry import JsonObjRegistry
from ..JsonAny import JsonAny
from ..JsonDate import JsonDate
from ..JsonDateTime import JsonDateTime
from ..JsonDuration import JsonDuration
from ..JsonList import JsonList
from ..JsonMap import JsonMap
from ..JsonObj import JsonObj
from ..JsonPrimitiveType import JsonPrimitiveType
from .. import JsonTypeCreation

from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestJsonTypeCreation(AxeSimpleTestCase):
  '''Unit test for the JsonTypeCreation class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    JsonObjRegistry.unregister("TestClass")

  #-----------------------------------------------------------------
  def testCreation(self) -> None:
    '''Test creating objects.
    '''

    # pylint: disable=W0232
    @ClassJsonClass([ClassJsonField('fooAttr', int)])
    class TestClass:
      def __init__(self, fooAttr: int) -> None:
        self.fooAttr = fooAttr

    obj1 = JsonTypeCreation.create('any')
    self.assertTrue(isinstance(obj1, JsonAny))

    obj2 = JsonTypeCreation.create(TestClass)
    self.assertTrue(isinstance(obj2, JsonObj))
    assert isinstance(obj2, JsonObj)
    self.assertEqual(obj2.objClass, TestClass)

    obj3 = JsonTypeCreation.create(int)
    self.assertTrue(isinstance(obj3, JsonPrimitiveType))

    obj4 = JsonTypeCreation.create(timedelta)
    self.assertTrue(isinstance(obj4, JsonDuration))

    obj5 = JsonTypeCreation.create(date)
    self.assertTrue(isinstance(obj5, JsonDate))

    obj6 = JsonTypeCreation.create(datetime)
    self.assertTrue(isinstance(obj6, JsonDateTime))

    obj7 = JsonTypeCreation.create([int])
    self.assertTrue(isinstance(obj7, JsonList))
    assert isinstance(obj7, JsonList)
    self.assertTrue(isinstance(obj7.itemType, JsonPrimitiveType))
    assert isinstance(obj7.itemType, JsonPrimitiveType)
    self.assertEqual(obj7.itemType.typeClass, int)

    obj8 = JsonTypeCreation.create({int: bool})
    self.assertTrue(isinstance(obj8, JsonMap))
    assert isinstance(obj8, JsonMap)
    self.assertTrue(isinstance(obj8.keyType, JsonPrimitiveType))
    self.assertTrue(isinstance(obj8.valueType, JsonPrimitiveType))


    try:
      JsonTypeCreation.create({int: bool, 'bad': 'extra'})
      self.fail("No exception for extra dict item.")
    except ClassJsonException:
      pass

    try:
      JsonTypeCreation.create([int, bool])
      self.fail("No exception for extra list item.")
    except ClassJsonException:
      pass

    try:
      JsonTypeCreation.create('blag')
      self.fail("No exception for bad type string.")
    except ClassJsonException:
      pass

    try:
      JsonTypeCreation.create(3)
      self.fail("No exception for bad type.")
    except ClassJsonException:
      pass

    # A class without a @ClassJsonClass annotation.
    class NotClassJsonClass:
      pass

    try:
      JsonTypeCreation.create(NotClassJsonClass)
      self.fail("No exception for missing @ClassJsonClass decoration.")
    except ClassJsonException:
      pass
