#-------------------------------------------------------------------
#  TestJsonDuration.py
#
#  The TestJsonDuration module.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Unit test for the JsonDuration class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from datetime import timedelta
from ai.axe.classJson.jsonTypes import JsonDuration
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestJsonDuration(AxeSimpleTestCase):
  '''Unit test for the JsonDuration class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testChildJsonObjs(self) -> None:
    '''Test the childJsonObjs() methods.
    '''

    self.assertEqual([], JsonDuration().childJsonObjs())

  #-----------------------------------------------------------------
  def testLabel(self) -> None:
    '''Test the toLabel() and str() methods.
    '''

    jsonType = JsonDuration()

    self.assertEqual('duration', jsonType.toLabel())
    self.assertIsNotNone(str(jsonType))

  #-----------------------------------------------------------------
  def testTypescriptLabel(self) -> None:
    '''Test the toTypescriptLabel() method.
    '''

    jsonType = JsonDuration()

    expected = 'Duration'
    actual = jsonType.toTypescriptLabel('')

    self.assertEqual(expected, actual)

  #-----------------------------------------------------------------
  def testTypescriptDesc(self) -> None:
    '''Test the toTypescriptDesc() methods.
    '''

    jsonType = JsonDuration()

    self.assertEqual('new JsonDuration()', jsonType.toTypescriptDesc())

  #-----------------------------------------------------------------
  def testEncodeDecode(self) -> None:
    '''Test the encode/decode() method.
    '''

    jsonType = JsonDuration()

    # An even number of milliseconds.
    even = timedelta(milliseconds=100000)

    # Fractional microseconds.
    fraction = timedelta(microseconds=10001)

    # Validate python.

    self.assertEqual(None, jsonType.validate(even), 'even valid')
    self.assertEqual(None, jsonType.validate(fraction), 'fraction valid')
    self.assertEqual(None, jsonType.validate(None), 'null valid')

    self.assertIsNotNone(jsonType.validate('invalid'), 'string invalid')
    self.assertIsNotNone(jsonType.validate(3.14), 'float invalid')

    # Validate JSON.

    self.assertEqual(None, jsonType.validateJson(100000), 'even valid JSON')
    self.assertEqual(None, jsonType.validateJson(None), 'null valid JSON')

    self.assertIsNotNone(jsonType.validateJson('invalid'), 'string invalid')
    self.assertIsNotNone(jsonType.validateJson(3.14), 'float invalid')

    # Encode.

    self.assertEqual(100000, jsonType.encode(even), 'even')
    self.assertEqual(10, jsonType.encode(fraction), 'fraction')
    self.assertEqual(None, jsonType.encode(None), 'null')

    # Decode.

    d100000 = jsonType.decode(100000)
    d0 = jsonType.decode(0)

    assert isinstance(d100000, timedelta)
    assert isinstance(d0, timedelta)

    self.assertEqual(100, d100000.total_seconds(), 'even')
    self.assertEqual(0, d0.total_seconds(), 'fraction')
    self.assertEqual(None, jsonType.decode(None), 'null')

    # Decode links.

    self.assertEqual(d100000, jsonType.decodeLinks([], d100000), 'timedelta')
    self.assertEqual(None, jsonType.decodeLinks([], None), 'null')
