#-------------------------------------------------------------------
#  TestJsonDateTime.py
#
#  The TestJsonDateTime module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the JsonDateTime class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from datetime import date
from datetime import datetime
from ai.axe.classJson.jsonTypes import JsonDateTime
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestJsonDateTime(AxeSimpleTestCase):
  '''Unit test for the JsonDateTime class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testChildJsonObjs(self) -> None:
    '''Test the childJsonObjs() methods.
    '''

    self.assertEqual([], JsonDateTime().childJsonObjs())

  #-----------------------------------------------------------------
  def testLabel(self) -> None:
    '''Test the toLabel() and str() methods.
    '''

    jsonType = JsonDateTime()

    self.assertEqual('datetime', jsonType.toLabel())
    self.assertIsNotNone(str(jsonType))

  #-----------------------------------------------------------------
  def testTypescriptLabel(self) -> None:
    '''Test the toTypescriptLabel() method.
    '''

    jsonType = JsonDateTime()

    expected = 'Date'
    actual = jsonType.toTypescriptLabel('')

    self.assertEqual(expected, actual)

  #-----------------------------------------------------------------
  def testTypescriptDesc(self) -> None:
    '''Test the toTypescriptDesc() methods.
    '''

    jsonType = JsonDateTime()

    self.assertEqual('new JsonDateTime()', jsonType.toTypescriptDesc())

  #-----------------------------------------------------------------
  def testEncodeDecode(self) -> None:
    '''Test the encode/decode() method.
    '''

    jsonType = JsonDateTime()

    # Validate python.

    self.assertEqual(None, jsonType.validate(datetime(2016, 1, 2)), 'is valid')
    self.assertEqual(None, jsonType.validate(None), 'null valid')

    self.assertIsNotNone(jsonType.validate('invalid'), 'string invalid')
    self.assertIsNotNone(jsonType.validate(3.14), 'float invalid')
    self.assertIsNotNone(jsonType.validate(date(2016, 1, 2)), 'date invalid')

    # Validate JSON.

    self.assertEqual(None,
                     jsonType.validateJson("2016-01-01T01:01:34.123Z"),
                     'date valid JSON')
    self.assertEqual(None, jsonType.validateJson(None), 'null valid JSON')

    self.assertIsNotNone(jsonType.validateJson('invalid'), 'string invalid')
    self.assertIsNotNone(jsonType.validateJson(3.14), 'float invalid')

    # Encode.

    self.assertEqual("2016-01-02T03:04:05.678Z",
                     jsonType.encode(datetime(2016, 1, 2, 3, 4, 5, 678000)),
                     'encode')
    self.assertEqual("2016-01-02T03:04:05.000Z",
                     jsonType.encode(datetime(2016, 1, 2, 3, 4, 5)),
                     'encode no millis')
    self.assertEqual(None, jsonType.encode(None), 'null')

    # Decode.

    self.assertEqual(datetime(2016, 1, 2, 3, 4, 5, 678000),
                     jsonType.decode("2016-01-02T03:04:05.678Z"),
                     'decode')
    self.assertEqual(datetime(2016, 1, 2, 3, 4, 5),
                     jsonType.decode("2016-01-02T03:04:05.000Z"),
                     'decode zero millis')
    self.assertEqual(datetime(2016, 1, 2, 3, 4, 5),
                     jsonType.decode("2016-01-02T03:04:05Z"),
                     'decode missing millis')
    self.assertEqual(datetime(2016, 1, 2, 3, 4, 5),
                     jsonType.decode("2016-01-02T03:04:05.Z"),
                     'decode missing millis with period')
    self.assertEqual(None, jsonType.decode(None), 'null')

    # Decode links.

    self.assertEqual(datetime(2016, 1, 2, 3, 4, 5),
                     jsonType.decodeLinks([], datetime(2016, 1, 2, 3, 4, 5)),
                     'decode links')
    self.assertEqual(None, jsonType.decodeLinks([], None), 'null')
