#-------------------------------------------------------------------
#  TestJsonDate.py
#
#  The TestJsonDate module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the JsonDate class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from datetime import date
from ai.axe.classJson.jsonTypes import JsonDate
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestJsonDate(AxeSimpleTestCase):
  '''Unit test for the JsonDate class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testChildJsonObjs(self) -> None:
    '''Test the childJsonObjs() methods.
    '''

    self.assertEqual([], JsonDate().childJsonObjs())

  #-----------------------------------------------------------------
  def testLabel(self) -> None:
    '''Test the toLabel() and str() methods.
    '''

    jsonType = JsonDate()

    self.assertEqual('date', jsonType.toLabel())
    self.assertIsNotNone(str(jsonType))

  #-----------------------------------------------------------------
  def testTypescriptLabel(self) -> None:
    '''Test the toTypescriptLabel() method.
    '''

    jsonType = JsonDate()

    expected = 'Day'
    actual = jsonType.toTypescriptLabel('')

    self.assertEqual(expected, actual)

  #-----------------------------------------------------------------
  def testTypescriptDesc(self) -> None:
    '''Test the toTypescriptDesc() methods.
    '''

    jsonType = JsonDate()

    self.assertEqual('new JsonDate()', jsonType.toTypescriptDesc())

  #-----------------------------------------------------------------
  def testEncodeDecode(self) -> None:
    '''Test the encode/decode() method.
    '''

    jsonType = JsonDate()

    # Validate python.

    self.assertEqual(None, jsonType.validate(date(2016, 1, 2)), 'date valid')
    self.assertEqual(None, jsonType.validate(None), 'null valid')

    self.assertIsNotNone(jsonType.validate('invalid'), 'string invalid')
    self.assertIsNotNone(jsonType.validate(3.14), 'float invalid')

    # Validate JSON.

    self.assertEqual(None,
                     jsonType.validateJson("2016-01-01"), 'date valid JSON')
    self.assertEqual(None, jsonType.validateJson(None), 'null valid JSON')

    self.assertIsNotNone(jsonType.validateJson('invalid'), 'string invalid')
    self.assertIsNotNone(jsonType.validateJson(3.14), 'float invalid')

    # Encode.

    self.assertEqual("2016-01-02", jsonType.encode(date(2016, 1, 2)), 'encode')
    self.assertEqual(None, jsonType.encode(None), 'null')

    # Decode.

    self.assertEqual(date(2016, 1, 2), jsonType.decode("2016-01-02"), 'decode')
    self.assertEqual(None, jsonType.decode(None), 'null')

    # Decode links.

    self.assertEqual(date(2016, 1, 2),
                     jsonType.decodeLinks([], date(2016, 1, 2)),
                     'decodeLinks')
    self.assertEqual(None, jsonType.decodeLinks([], None), 'null')
