#-------------------------------------------------------------------
#  TestJsonAny.py
#
#  The TestJsonAny module.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Unit test for the JsonAny class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson.jsonTypes import JsonAny
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestJsonAny(AxeSimpleTestCase):
  '''Unit test for the JsonAny class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testChildJsonObjs(self) -> None:
    '''Test the childJsonObjs() methods.
    '''

    self.assertEqual([], JsonAny().childJsonObjs())

  #-----------------------------------------------------------------
  def testLabel(self) -> None:
    '''Test the toLabel() and str() methods.
    '''

    jsonType = JsonAny()

    self.assertIsNotNone(jsonType.toLabel())
    self.assertIsNotNone(str(jsonType))

  #-----------------------------------------------------------------
  def testTypescriptLabel(self) -> None:
    '''Test the toTypescriptLabel() methods.
    '''

    jsonType = JsonAny()

    self.assertEqual('any', jsonType.toTypescriptLabel(''))

  #-----------------------------------------------------------------
  def testTypescriptDesc(self) -> None:
    '''Test the toTypescriptDesc() methods.
    '''

    jsonType = JsonAny()

    self.assertEqual('new JsonAny()', jsonType.toTypescriptDesc())

  #-----------------------------------------------------------------
  def testValidate(self) -> None:
    '''Test the validate() method.
    '''

    jsonType = JsonAny()
    self.assertIsNone(jsonType.validate(None))
    self.assertIsNone(jsonType.validate('foo'))
    self.assertIsNone(jsonType.validate(True))
    self.assertIsNone(jsonType.validate(3))
    self.assertIsNone(jsonType.validate([[[]]]))

  #-----------------------------------------------------------------
  def testValidateJson(self) -> None:
    '''Test the validateJson() method.
    '''

    jsonType = JsonAny()
    self.assertIsNone(jsonType.validateJson(None))
    self.assertIsNone(jsonType.validateJson('foo'))
    self.assertIsNone(jsonType.validateJson(True))
    self.assertIsNone(jsonType.validateJson(3))
    self.assertIsNone(jsonType.validateJson([[[]]]))

  #-----------------------------------------------------------------
  def testEncode(self) -> None:
    '''Test the encode() method.
    '''

    jsonType = JsonAny()
    self.assertEqual(None, jsonType.encode(None), 'null')
    self.assertEqual(3, jsonType.encode(3), 'no change')

  #-----------------------------------------------------------------
  def testDecode(self) -> None:
    '''Test the decode() method.
    '''

    jsonType = JsonAny()
    self.assertEqual(None, jsonType.decode(None), 'null')
    self.assertEqual(3, jsonType.decode(3), 'no change')

  #-----------------------------------------------------------------
  def testDecodeLinks(self) -> None:
    '''Test the decodeLinks() method.
    '''

    jsonType = JsonAny()
    self.assertEqual(None, jsonType.decodeLinks([], None), 'null')
    self.assertEqual(3, jsonType.decodeLinks([], 3), 'no change')
