#-------------------------------------------------------------------
#  JsonTypeError.py
#
#  The JsonTypeError class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the JsonTypeError class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class JsonTypeError:
  '''An error that prevents an object/JSON encoding or decoding.
  '''

  #-----------------------------------------------------------------
  def __init__(self, message):
    '''Creates a new JsonTypeError.
    '''

    # The path into the JSON document that is the error location.
    self.path = ''

    # The error message.
    self.message = message

  #-----------------------------------------------------------------
  def prependPath(self, element):
    '''Adds a string element to the path.

    @param element A string to be added to the path.
    '''

    # Before a list/dictionary subscript, no slash is needed.
    # Otherwise, prepend a slash.

    if self.path and self.path[0] != '[':
      element += '/'

    self.path = element + self.path

  #-----------------------------------------------------------------
  def prependPathIndex(self, index):
    '''Adds a numeric index to the path.

    @param element A string to be added to the path.
    '''

    indexStr = '[%s]' % index

    if self.path and self.path[0] != '[':
      indexStr += '/'

    self.path = indexStr + self.path

  #-----------------------------------------------------------------
  def prependPathKey(self, key):
    '''Adds a dictionary key to the path.

    @param element A string to be added to the path.
    '''

    keyStr = '[%s]' % key

    if self.path and self.path[0] != '[':
      keyStr += '/'

    self.path = keyStr + self.path

  #----------------------------------------------------------------
  def format(self):
    '''Formats this object into a pleasant message.
    '''

    return 'The element at location /%s %s' % (self.path, self.message)

  #----------------------------------------------------------------
  def __repr__(self):
    '''Returns a string representation of this object
    '''
    attrs = ['path', 'message']

    return StringUtil.formatRepr(self, attrs)
