#-------------------------------------------------------------------
#  JsonType.py
#
#  The JsonType class.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''The module containing the JsonType class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .JsonTypeError import JsonTypeError
from ai.axe.util import StringUtil
from typing import List
from typing import Optional
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class JsonType:
  '''Marks a class attribute for encoding to/from JSON.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new JsonType.
    '''

    pass

  #-----------------------------------------------------------------
  def validate(self, value: object) -> Optional[JsonTypeError]:
    '''Checks that the specified value can be converted to JSON.

    @param value The value to validate.

    @return None if the value is OK, or a JsonTypeError if there is a problem.
    '''

    # Suppress argument not used warning.
    # pylint: disable=self-assigning-variable
    value = value

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def validateJson(self, value: object) -> Optional[JsonTypeError]:
    '''Checks that the specified JSON string can be converted to an object.

    @param value The JSON value to validate.

    @return None if the value is OK, or a JsonTypeError if there is a problem.
    '''

    # Suppress argument not used warning.
    # pylint: disable=self-assigning-variable
    value = value

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def encode(self, value: object) -> object:
    '''Encodes a value into JSON-ready value.
    '''

    # Suppress argument not used warning.
    # pylint: disable=self-assigning-variable
    value = value

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def decode(self, value: object) -> object:
    '''Decodes a value from a JSON-ready value.
    '''

    # Suppress argument not used warning.
    # pylint: disable=self-assigning-variable
    value = value

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def decodeLinks(self, parents: List[object], value: object) -> object:
    '''Decodes any links in a JSON-ready value.
    '''

    # Suppress argument not used warning.
    # pylint: disable=self-assigning-variable
    parents = parents
    value = value

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def childJsonObjs(self) -> List['JsonType']:
    '''Returns all JsonObj types that are children of this type.

    @return A list of JsonObj objects.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def toLabel(self) -> str:
    '''Returns a label for this type for display for a user.

    @return A string.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def toTypescriptLabel(self, namespace: str) -> str:
    '''Returns a label for this type for display for a user.

    @param namespace The namespace that any types should be placed in.

    @return A typescript string.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def toTypescriptDesc(self) -> str:
    '''Returns typescript code to create a JsonType object for this type.

    @return A typescript string.
    '''

    # The default implementation is to use this class name.
    # Classes that have extra parameters will have to implement
    # an override of this method.

    classNameNoPackage = self.__class__.__name__.split('.')[-1]

    return 'new %s()' % classNameNoPackage

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs: List[str] = []

    return StringUtil.formatRepr(self, attrs)
