#-------------------------------------------------------------------
#  __init__.py
#
#  The __init__ module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''ClassJson enables serializing/deserialing objects to/from JSON.

To set up a class for use with classJson, mark it with the @ClassJsonClass()
decorator like so:

  @ClassJsonClass([ClassJsonField('name2', 'string'),
                   ClassJsonField('x2', 'int'),
                   ClassJsonField('y2', 'int')])
  class TestClass3:
    pass
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .ClassJsonDecoder import ClassJsonDecoder
from .ClassJsonEncoder import ClassJsonEncoder
from .ClassJsonException import ClassJsonException
from .ClassJsonField import ClassJsonField
from .ClassJsonFieldDesc import ClassJsonFieldDesc
from .ClassJsonClass import ClassJsonClass
from .ClassJsonClassDesc import ClassJsonClassDesc
from .ClassJsonLink import ClassJsonLink
from .ClassJsonSchemaWriter import ClassJsonSchemaWriter
from .ClassJsonTypescriptWriter import ClassJsonTypescriptWriter
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------
