#-------------------------------------------------------------------
#  ClassJsonFieldDesc.py
#
#  The ClassJsonFieldDesc class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the ClassJsonFieldDesc class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .jsonTypes.JsonType import JsonType
from ai.axe.util import StringUtil
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class ClassJsonFieldDesc:
  '''Description how to serialize a single field of a class.
  '''

  #-----------------------------------------------------------------
  def __init__(self, name: str, jsonType: JsonType) -> None:
    '''Creates a new ClassJsonFieldDesc.

    @param name The name of the field.
    @param jsonType The type of the field.
    '''

    # The name of this field.
    self.name: str = name

    # The type of this field.
    self.jsonType: JsonType = jsonType

  #-----------------------------------------------------------------
  def __repr__(self) -> str:

    showFields = ['name', 'jsonType']
    return StringUtil.formatRepr(self, showFields)
