#-------------------------------------------------------------------
#  ClassJsonField.py
#
#  The ClassJsonField class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the ClassJsonField class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .ClassJsonFieldDesc import ClassJsonFieldDesc
from .jsonTypes import JsonTypeCreation
from ai.axe.util import StringUtil
from typing import Any
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class ClassJsonField:
  '''Information about a single field.
  '''

  #-----------------------------------------------------------------
  def __init__(self, name: str, jsonType: Any) -> None:
    '''Creates a new ClassJsonField.

    @param name The name of the field.
    @param jsonType One of:  a @ClassJsonClass-decorated class object,
                    a dictionary or list, or a Python type object:
                    bool, int, float, str, date, datetime, timedelta.
    '''

    # The name of this field.
    self.name: str = name

    # The type of this field.
    self.jsonType: Any = jsonType

  #-----------------------------------------------------------------
  def toDesc(self) -> ClassJsonFieldDesc:
    '''Returns a ClassJsonFieldDesc equivalent to this object.
    '''

    return ClassJsonFieldDesc(self.name, JsonTypeCreation.create(self.jsonType))

  #-----------------------------------------------------------------
  def __repr__(self) -> str:

    showFields = ['name', 'jsonType']
    return StringUtil.formatRepr(self, showFields)
