#-------------------------------------------------------------------
#  ClassJsonEncoder.py
#
#  The ClassJsonEncoder class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the ClassJsonEncoder class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
import json
from .ClassJsonException import ClassJsonException
from .jsonTypes.JsonObj import JsonObj
from .jsonTypes.JsonObjRegistry import JsonObjRegistry
from typing import Optional
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class ClassJsonEncoder:
  '''Encodes an object into JSON.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new ClassJsonEncoder.
    '''

    pass

  #-----------------------------------------------------------------
  def encode(self, obj: object, indent: Optional[int] = None) -> str:
    '''Encodes the specified object into JSON.

    @param obj The object to be encoded.
    @param indent The indent, as documented in the Python json.dump() docs.

    @return a JSON string.
    '''

    clazz = obj.__class__

    if not JsonObjRegistry.classIsRegistered(clazz):
      msg = "Attempting to JSON-encode an object that is not decorated with "
      msg += "@ClassJsonClass. \nClass: %s \nObject: %s" % (clazz, obj)
      raise ClassJsonException(msg)

    classJsonType: JsonObj = JsonObjRegistry.getForClass(clazz)

    errorMsg = classJsonType.validate(obj)
    if errorMsg:
      msg = errorMsg.format()
      msg += "\n\nUnable to encode object:\n%s" % obj
      raise ClassJsonException(msg)

    jsonDict = classJsonType.encode(obj)

    jsonStr = json.dumps(jsonDict,
                         ensure_ascii=False,
                         indent=indent)
    return jsonStr
