#-------------------------------------------------------------------
#  util.py
#
#  The util module.
#
#  Copyright 2013  Applied Invention, LLC.
#-------------------------------------------------------------------

"""Utility build functions.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import Any
import re
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------
def newSectionProgress(sectionName: str) -> None:
  verbose = False
  if verbose:
    sys.stdout.write(sectionName)
  else:
    sys.stdout.write('.')

  sys.stdout.flush()

#----------------------------------------------------------------------
def silent(target: Any, source: Any, env: Any):
  """Use this function as a status message function if you want a command
  to be silent.
  """

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  target = target
  source = source
  env = env

  return ''

#----------------------------------------------------------------------
srcNameRe = re.compile('src/python/(.*).py')

#----------------------------------------------------------------------
def splitPySrc(srcFile: str) -> str:
  """Given a python source file name, returns its base name.

  For example, src/python/a/b/c.py will return:

    'a/b/c'
  """

  match = srcNameRe.match(srcFile)
  assert match, 'No match: %s' % srcFile
  baseName = match.group(1)

  return baseName
