#-------------------------------------------------------------------
#  Tsc.py
#
#  The Tsc module.
#
#  Copyright 2006  Applied Invention, LLC.
#-------------------------------------------------------------------

"""A unittest Builder for SCons.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.web.build import Typescript
from SCons.Environment import Base as SconsEnvironment
from SCons.Node import Node
from typing import List
import SCons
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------


#-------------------------------------------------------------------
def addTscBuilder(env: SconsEnvironment) -> None:
  """Adds the Tsc builder to the specified environment.

  Call this function with your SCons.Environment if you want to build
  unittests.  After calling this function, you can build unit test
  runs like so:

     env.Tsc('build/webapp/foo.js', ['src/file1.ts', 'src/file2.ts'])

  @param env An SCons.Environment object.
  """

  # The Tsc builer.

  actions = [
    SCons.Action.Action(compileTs, "Compiling typescript..."),
    SCons.Action.Action(pack, "Packing javascript to ${TARGET}..."),
  ]

  builder = SCons.Builder.Builder(action=actions)
  env.Append(BUILDERS={'Tsc': builder})

#-------------------------------------------------------------------
def compileTs(target: List[Node],
              source: List[Node],
              env: SconsEnvironment) -> int:

  assert len(source) >= 1
  assert len(target) == 1

  # Suppress unused variable warning.
  # pylint: disable=self-assigning-variable
  env = env

  targetFile = str(target[0])
  sourceFileNames = [str(x) for x in source]

  # Return non-zero to make the build fail.
  return Typescript.compileTs(targetFile, sourceFileNames)

#-------------------------------------------------------------------
def pack(target: List[Node], source: List[Node], env: SconsEnvironment) -> int:

  assert len(source) >= 1
  assert len(target) == 1

  # Suppress unused variable warning.
  # pylint: disable=self-assigning-variable
  env = env

  targetFile = str(target[0])

  # Return non-zero to make the build fail.
  return Typescript.pack(targetFile)
