#-------------------------------------------------------------------
#  TsLint.py
#
#  The TsLint module.
#
#  Copyright 2006  Applied Invention, LLC.
#-------------------------------------------------------------------

"""A unittest Builder for SCons.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
import SCons
from .Util import silent
from SCons.Environment import Base as SconsEnvironment
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------


#-------------------------------------------------------------------
def addTsLintBuilder(env: SconsEnvironment) -> None:
  """Adds the TsLint builder to the specified environment.

  Call this function with your SCons.Environment to lint .ts files.
  After calling this function, you can lint files like so:

     env.TsLint('build/webapp/foo.js', ['src/file1.ts', 'src/file2.ts'])

  @param env An SCons.Environment object.
  """

  # The TsLint builer.

  cmd = ("$NODE $TSLINT --formatters-dir admin/ts --format EmacsFriendly " +
         "$SOURCES")

  actions = [
    SCons.Action.Action(cmd, "Linting Typescript files..."),
    SCons.Action.Action("cat $SOURCES > $TARGET", silent),
  ]

  builder = SCons.Builder.Builder(action=actions)
  env.Append(BUILDERS={'TsLint': builder})
