#-------------------------------------------------------------------
#  parse.py
#
#  The parse module.
#
#  Copyright 2013  Applied Invention, LLC.
#-------------------------------------------------------------------

"""Functions to parse documents.
"""

#-------------------------------------------------------------------
# Import statements go here.
#

#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------
def blankComments(text: str) -> str:
  '''Returns the input text with comments blanked out.

  Newlines are preserved, so line numbers will be correct.
  '''

  lines = text.split('\n')

  amInCComment = False
  for lineIndex, line in enumerate(lines):

    cBeginStr = '/*'
    cEndStr = '*/'

    # C-style comment begin index.
    cBeginIndex = line.find(cBeginStr)

    # C-style comment end index.
    cEndIndex = line.find(cEndStr)

    if not amInCComment:
      if cBeginIndex > -1 and cEndIndex > -1:
        line = line[:cBeginIndex] + line[cEndIndex + len(cEndStr):]
      elif cBeginIndex > -1:
        amInCComment = True
        line = line[:cBeginIndex]
    else:
      if cEndIndex > -1:
        amInCComment = False
        line = line[cEndIndex + len(cEndStr):]
      else:
        line = ''

    cppCommentIndex = line.find('//')
    if cppCommentIndex > -1:
      line = line[:cppCommentIndex]

    lines[lineIndex] = line

  return '\n'.join(lines)

#-------------------------------------------------------------------
def test() -> None:
  '''Run unit tests.
  '''

  text = '''
int i;
// int j;
int k;
'''

  expected = '''
int i;

int k;
'''

  actual = blankComments(text)
  check(expected, actual)

  text = '''
int i;
/* int j; */
int k;
'''

  expected = '''
int i;

int k;
'''

  actual = blankComments(text)
  check(expected, actual)


  text = '''
int i;
/* int j;
int k; */int l;
int m;
'''

  expected = '''
int i;

int l;
int m;
'''

  actual = blankComments(text)
  check(expected, actual)

#-------------------------------------------------------------------
def check(expected: str, actual: str) -> None:
  '''Check that the expected text matches the actual text.
  '''

  if actual != expected:
    msg = ('\n=========\nexpected:\n' + expected + '\n========\n' +
           'actual:\n' + actual)
    assert False, msg
