#-------------------------------------------------------------------
#  error.py
#
#  The error module.
#
#  Copyright 2013  Applied Invention, LLC.
#-------------------------------------------------------------------

"""Functions to display build errors.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
import os.path
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def buildError(fileName: str, lineNum: int, msg: str) -> None:
  '''Displays an error and halts the build.

  This function should only be used when there is an error while setting
  up the build graph.  Normal errors should be reported via the normal
  SCons method (write an error to stderr and return non-zero).
  '''

  aristotleHome = os.environ['ARISTOTLE_HOME']

  if not fileName.startswith(aristotleHome):
    fileName = os.path.join(aristotleHome, fileName)

  lineNum += 1

  fullMsg = '\nError:' + fileName + ':' + str(lineNum) + ': ' + msg + '\n'
  sys.stderr.write(fullMsg)

  sys.exit(-1)
