#-------------------------------------------------------------------
#  Defaults.py
#
#  The Defaults module.
#
#  Copyright 2013  Applied Invention, LLC.
#-------------------------------------------------------------------

"""Replaces functions in the SCons.Defaults module.

These actions acts like the SCons.Defaults actions, but they write
no status message.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
import SCons.Action
import SCons.Defaults
from . import Copy
import os.path
from .Util import silent
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------
def makeLink(src: str, dest: str) -> None:
  '''Function to create a symbolic link.'''

  if os.path.exists(dest):
    os.unlink(dest)

  os.symlink(src, dest)

#-------------------------------------------------------------------
ActionFactory = SCons.Action.ActionFactory

#-------------------------------------------------------------------

# The following are 'silent' version of SCons function that can be
# used to build Actions.

# pylint: disable=C0103
Copy = Copy.action
Delete = ActionFactory(SCons.Defaults.delete_func, silent)
Link = ActionFactory(makeLink, silent)
Mkdir = ActionFactory(SCons.Defaults.mkdir_func, silent)
# pylint: enable=C0103
