#-------------------------------------------------------------------
#  Copy.py
#
#  The Copy module.
#
#  Copyright 2013  Applied Invention, LLC.
#-------------------------------------------------------------------

"""A Copy action that replaces the deafult.

The Copy action acts like the built-in action, but writes no status message.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
import os.path
import shutil
import SCons
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
# Acts like the built-in Copy, but with no status message.

action = SCons.Action.ActionFactory(SCons.Defaults.copy_func,
                                    lambda dest, src: '',
                                    convert=str)

#-------------------------------------------------------------------
def copyNoLinkFunc(dest: str, src: str) -> None:
  '''Copies a file.

  Acts like the built-in copy, except doesn't preserve a symlink.
  Instead copies the link target.'''

  return SCons.Defaults.copy_func(dest, src, symlinks=False)

#-------------------------------------------------------------------
# Like the built-in Copy, but copies symlink targets.

noLinkAction = SCons.Action.ActionFactory(copyNoLinkFunc,
                                          lambda dest, src: '',
                                          convert=str)
#-------------------------------------------------------------------
def copyTreeFunc(dest: str, src: str) -> None:
  '''Copies a directory.

  Acts like the built-in copy, except doesn't throw an error
  when the target directory already exists.'''

  if os.path.isdir(dest):
    shutil.rmtree(dest)
  return SCons.Defaults.copy_func(dest, src)

#-------------------------------------------------------------------
# Like the built-in Copy, but no error if copying to a directory that exists.

treeAction = SCons.Action.ActionFactory(copyTreeFunc,
                                        lambda dest, src: '',
                                        convert=str)
