#-------------------------------------------------------------------
# coverage.py
#
# The coverage module.
#
# Copyright 2013  Applied Invention, LLC.
#-------------------------------------------------------------------

"""Unit test coverage testing functions.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
from ..BuildSetup import BuildSetup
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------
def minCoverage(className: str) -> float:
  """Returns the minimum coverage a class must have to pass.

  @param className The class being tested.

  @return The percentage of coverage required.
  """

  relaxations = BuildSetup.get().coverageRelaxations()

  # Normally, classes must have 90% coverage.
  usualMin = 90

  if className in relaxations:
    return relaxations[className]
  else:
    return usualMin
