#-------------------------------------------------------------------
#  PyTest.py
#
#  The PyTest class.
#
#  Copyright 2020 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the PyTest class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
from .. import NewClassCommand
from .. import NewClassWriter
from typing import List
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class PyTest(NewClassCommand):
  '''Command to create a new Python unit test.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new PyTest.
    '''

    NewClassCommand.__init__(self)

  #-----------------------------------------------------------------
  def name(self) -> str:
    '''Returns the name of this command.

    @return A string name, such as 'pyClass' or 'ngDirective'.
    '''

    return "pyTest"

  #-----------------------------------------------------------------
  def shortDescription(self) -> str:
    '''Returns a short (less than 60 characters) description of this command.

    @return A string description of what this class creates,
            such as 'A Python class.'
    '''

    return "A Python unit test"

  #-----------------------------------------------------------------
  def usage(self) -> str:
    '''Returns the usage string for this command.
    '''

    return "Usage:  newClass pyTest class_name"

  #-----------------------------------------------------------------
  def usageDescription(self) -> str:
    '''Returns the usage and description paragraph for this command.
    '''

    return self.usage() + """

Creates a new 'Testclass_name.py' file with a skeleton unittest in it.
"""

  #-----------------------------------------------------------------
  def execute(self, args: List[str]) -> None:
    '''Execute this command.

    @param args The command-line arguments from the user.
    '''

    if '-h' in args or '--help' in args:
      print(self.usageDescription())
      sys.exit(1)

    names = {}

    if len(args) > 1:
      print("Error: too many arguments.")
      print(self.usage())
      sys.exit(1)

    if not args:
      print("Error: missing argument.")
      print(self.usage())
      sys.exit(1)

    className = args.pop(0)

    if className.endswith('.py'):
      className = className[:-3]
    if className.startswith('test') or className.startswith('Test'):
      className = className[4:]

    outFile = 'Test' + className + '.py'
    names['CLASS_NAME'] = className

    NewClassWriter.genFile(PyTest.template, names, outFile)

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs: List[str] = []

    return StringUtil.formatRepr(self, attrs)

  #----------------------------------------------------------------
  template = """\
#-------------------------------------------------------------------
#  Test${CLASS_NAME}.py
#
#  The Test${CLASS_NAME} module.
#
#  2021 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the ${CLASS_NAME} class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class Test${CLASS_NAME}(AxeTestCase):
  '''Unit test for the ${CLASS_NAME} class.
  '''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testSomeTest(self) -> None:
    '''Put a description of what's being tested here.
    '''

    x = 10
    self.assertEqual(10, x, 'value of x')
"""
