#-------------------------------------------------------------------
#  PyModule.py
#
#  The PyModule class.
#
#  Copyright 2020 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the PyModule class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
from .. import NewClassCommand
from .. import NewClassWriter
from typing import List
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class PyModule(NewClassCommand):
  '''Command to create a new Python class.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new PyModule.
    '''

    NewClassCommand.__init__(self)

  #-----------------------------------------------------------------
  def name(self) -> str:
    '''Returns the name of this command.

    @return A string name, such as 'pyClass' or 'ngDirective'.
    '''

    return "pyModule"

  #-----------------------------------------------------------------
  def shortDescription(self) -> str:
    '''Returns a short (less than 60 characters) description of this command.

    @return A string description of what this class creates,
            such as 'A Python class.'
    '''

    return "A Python module"

  #-----------------------------------------------------------------
  def usage(self) -> str:
    '''Returns the usage string for this command.
    '''

    return "Usage:  Usage:  newPyModule module_name"

  #-----------------------------------------------------------------
  def usageDescription(self) -> str:
    '''Returns the usage and description paragraph for this command.
    '''

    return self.usage() + """

Creates a new 'module_name.py' file with a skeleton module in it.
"""

  #-----------------------------------------------------------------
  def execute(self, args: List[str]) -> None:
    '''Execute this command.

    @param args The command-line arguments from the user.
    '''

    if '-h' in args or '--help' in args:
      print(self.usageDescription())
      sys.exit(1)

    names = {}

    if len(args) > 1:
      print("Error: too many arguments.")
      print(self.usage())
      sys.exit(1)

    if not args:
      print("Error: missing argument.")
      print(self.usage())
      sys.exit(1)

    names['MODULE_NAME'] = args.pop(0)
    if names['MODULE_NAME'].endswith('.py'):
      names['MODULE_NAME'] = names['MODULE_NAME'][:-3]
    outFile = names['MODULE_NAME'] + '.py'

    NewClassWriter.genFile(PyModule.template, names, outFile)

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs: List[str] = []

    return StringUtil.formatRepr(self, attrs)

  #----------------------------------------------------------------
  template = """\
#-------------------------------------------------------------------
#  ${MODULE_NAME}.py
#
#  The ${MODULE_NAME} module.
#
#  2021 Applied Invention, LLC
#-------------------------------------------------------------------

'''Add module documentation docstring here.
'''  Add module documentation docstring here.

#-------------------------------------------------------------------
# Import statements go here.
#

#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def someFunction(foo: str, numBar: int) -> str:
  '''One-line description of this function.

  Long description of what this does.

  @exception FooException if there's a problem with the foo.

  @param foo the name of the foo.
  @param numBar how many bars are expected to be returned.

  @return an XML string.
  '''

  if something:
    xml += "1"
  else:
    xml += "2"

  return xml
"""
