#-------------------------------------------------------------------
#  BrowserTest.py
#
#  The BrowserTest class.
#
#  Copyright 2020 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the BrowserTest class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
from .. import NewClassCommand
from .. import NewClassWriter
from typing import List
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class BrowserTest(NewClassCommand):
  '''Command to create a new browser-based test.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new BrowserTest.
    '''

    NewClassCommand.__init__(self)

  #-----------------------------------------------------------------
  def name(self) -> str:
    '''Returns the name of this command.

    @return A string name, such as 'pyClass' or 'ngDirective'.
    '''

    return "browserTest"

  #-----------------------------------------------------------------
  def shortDescription(self) -> str:
    '''Returns a short (less than 60 characters) description of this command.

    @return A string description of what this class creates,
            such as 'A Python class.'
    '''

    return "A browser-based test."

  #-----------------------------------------------------------------
  def usage(self) -> str:
    '''Returns the usage string for this command.
    '''

    return "Usage:  newClass browserTest test_name"

  #-----------------------------------------------------------------
  def usageDescription(self) -> str:
    '''Returns the usage and description paragraph for this command.
    '''

    return self.usage() + """

Creates a new 'Test_name.py' file with a skeleton browser test in it.
"""

  #-----------------------------------------------------------------
  def execute(self, args: List[str]) -> None:
    '''Execute this command.

    @param args The command-line arguments from the user.
    '''

    if '-h' in args or '--help' in args:
      print(self.usageDescription())
      sys.exit(1)

    names = {}

    if len(args) > 1:
      print("Error: too many arguments.")
      print(self.usage())
      sys.exit(1)

    if not args:
      print("Error: missing argument.")
      print(self.usage())
      sys.exit(1)

    className = args.pop(0)

    if className.endswith('.py'):
      className = className[:-3]
    if className.startswith('test') or className.startswith('Test'):
      className = className[4:]

    outFile = 'Test' + className + '.py'
    names['CLASS_NAME'] = className

    NewClassWriter.genFile(BrowserTest.template, names, outFile)

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs: List[str] = []

    return StringUtil.formatRepr(self, attrs)

  #----------------------------------------------------------------
  template = """\
#-------------------------------------------------------------------
#  Test${CLASS_NAME}.py
#
#  The Test${CLASS_NAME} module.
#
#  2021 Applied Invention, LLC
#-------------------------------------------------------------------

'''Integration test that runs in a Web browser.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeBrowserTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class Test${CLASS_NAME}(AxeBrowserTestCase):
  '''Browser-basedintegration test.
'''

  #-----------------------------------------------------------------
  def setUp(self):

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self):

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testSomeTest(self):
    '''Put a description of what's being tested here.
    '''

    browser = self.getAppBrowser()

    x = 10
    self.assertEqual(x, 10)
"""
