#-------------------------------------------------------------------
#  NewClassWriter.py
#
#  The NewClassWriter module.
#
#  Copyright 2013 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Allow developers to generate a new class file from a template.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import Dict
import os
import string
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def genFile(fileTemplate: str,
            replaceDict: Dict[str, str],
            outFileName: str) -> bool:
  """Generates a new source code file from a template.

  @param fileTemplate Template for contents of the file.
  @param replaceDict Parameters to replace in the file.
  @param outFileName The file to write.
  """

  # If there's a VAR_NAME, also create a blank string VR_BLANK.
  if 'VAR_NAME' in replaceDict:
    replaceDict['VR_BLANK'] = ' ' * len(replaceDict['VAR_NAME'])

  template = string.Template(fileTemplate)
  text = template.substitute(replaceDict)

  canWrite = True

  if os.path.exists(outFileName):

    print("File '" + outFileName + "' already exists.  Overwrite? [y/N]")
    overwriteStr = sys.stdin.readline()
    overwriteStr = overwriteStr.strip()

    if overwriteStr.lower() != 'y' and overwriteStr.lower() != 'yes':

      print("Refusing to overwrite.  No file '" + outFileName + "' written.")
      canWrite = False

  if canWrite:

    print("Creating file '" + outFileName + "'...")
    open(outFileName, 'w').write(text)

  return canWrite
