#-------------------------------------------------------------------
#  NewClassCommand.py
#
#  The NewClassCommand class.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the NewClassCommand class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class NewClassCommand:
  '''A type of file that the newClass command can generate.

  Inherit from this class register it with NewClass to allow users
  to create this kind of file.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new NewClassCommand.
    '''

    pass

  #-----------------------------------------------------------------
  def name(self) -> str:
    '''Returns the name of this command.

    @return A string name, such as 'pyClass' or 'ngDirective'.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def shortDescription(self) -> str:
    '''Returns a short (less than 60 characters) description of this command.

    @return A string description of what this class creates,
            such as 'A Python class.'
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def usage(self) -> str:
    '''Returns the usage string for this command.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def usageDescription(self) -> str:
    '''Returns the usage and description paragraph for this command.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def execute(self, args: List[str]) -> None:
    '''Execute this command.

    @param args The command-line arguments from the user.
    '''

    raise NotImplementedError()
