#-------------------------------------------------------------------
#  BuildPlatform.py
#
#  The BuildPlatform module.
#
#  2021 Applied Invention, LLC
#-------------------------------------------------------------------

'''The OS/hardware platform being built upon.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
import os
import platform as platformModule
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def platform() -> str:
  '''Returns one of:  redhat, ubuntu-x64, ubuntu-arm64, darwin

  Note that the syncTools script toolsPlatform() function should
  probably be kept in sync with this.
  '''

  shortMachines = {'x86_64': 'x64',
                   'aarch64': 'arm64'}

  machine = platformModule.uname().machine
  machine = shortMachines[machine]

  thePlatform = platformModule.system().lower()

  if thePlatform == 'linux':

    if os.path.isfile('/etc/redhat-release'):
      thePlatform = 'redhat'
    else:
      thePlatform = 'ubuntu-' + machine

  return thePlatform
