//------------------------------------------------------------------
//  TestJsonTypeError.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../../util/string";
import { UnitTest } from '../../../unittest/UnitTest';
import { UnitTestRunner } from '../../../unittest/UnitTestRunner';
import { JsonTypeError} from '../JsonTypeError';
//------------------------------------------------------------------

/** Unit test for the JsonTypeError class.
 */
export class TestJsonTypeError extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonTypeError object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /** Test creating an error.
   */
  testCreate() : void
  {
    let err = new JsonTypeError('message');

    err.prependPath('f');
    err.prependPath('e');
    err.prependPath('d');
    err.prependPathKey('foo');
    err.prependPath('c');
    err.prependPathIndex(3);
    err.prependPath('b');
    err.prependPath('a');

    this.assertEqual('message', err.message, 'message');
    this.assertEqual('path', 'a/b[3]/c[foo]/d/e/f', err.path);

    this.assertNotNull('format is not null', err.format());
    this.assertNotNull('str() is not null', "" + err);
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestJsonTypeError

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestJsonTypeError());
