//------------------------------------------------------------------
//  TestJsonDuration.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import { Duration } from "../../../date/Duration";
import * as axeString from "../../../util/string";
import { UnitTest } from "../../../unittest/UnitTest";
import { UnitTestRunner } from "../../../unittest/UnitTestRunner";
import { JsonDuration } from "../JsonDuration";
//------------------------------------------------------------------

/** Unit test for the JsonDuration class.
 */
export class TestJsonDuration extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonDuration object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /** Test the encode/decode() method.
   */
  testEncodeDecode() : void
  {
    let jsonType = new JsonDuration();

    // An even number of milliseconds.
    let even = new Duration(100000);

    // Fractional microseconds.
    let fraction = new Duration(10);
    fraction.milliseconds += .001;

    // Validate python.

    this.assertEqual('even valid', null, jsonType.validate(even));
    this.assertEqual('null valid', null, jsonType.validate(null));

    this.assertNotNull('fraction invalid', jsonType.validate(fraction));
    this.assertNotNull('string invalid', jsonType.validate('invalid'));
    this.assertNotNull('float invalid', jsonType.validate(3.14));

    // Validate JSON.

    this.assertEqual('even valid JSON', null, jsonType.validateJson(100000));
    this.assertEqual('null valid JSON', null, jsonType.validateJson(null));

    this.assertNotNull('string invalid', jsonType.validateJson('invalid'));
    this.assertNotNull('JSON fraction invalid', jsonType.validateJson(3.14));

    // Encode.

    this.assertEqual('encode even', 100000, jsonType.encode(even));
    this.assertEqual('encode null', null, jsonType.encode(null));

    // Decode.

    this.assertEqual('de even', 100000, jsonType.decode(100000).milliseconds);
    this.assertEqual('de zero', 0, jsonType.decode(0).milliseconds);
    this.assertEqual('decode null', null, jsonType.decode(null));

    // Decode links.

    this.assertEqual('duration', even, jsonType.decodeLinks([], even));
    this.assertEqual('null', null, jsonType.decodeLinks([], null));
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestJsonDuration

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestJsonDuration());
