"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSpeedFactorConvertExpression = exports.convertSpeedFactorToDuration = void 0;
/** Converts the specified speed factor into the exact static enter duration. */
function convertSpeedFactorToDuration(factor) {
    // Based on the numeric speed factor value that only affected the `enterDuration` we can
    // now calculate the exact `enterDuration`. 450ms is the enter duration without factor.
    return 450 / (factor || 1);
}
exports.convertSpeedFactorToDuration = convertSpeedFactorToDuration;
/**
 * Creates a runtime TypeScript expression that can be used in order to calculate the duration
 * from the speed factor expression that couldn't be statically analyzed.
 *
 * @param speedFactorValue Speed factor expression that couldn't be statically analyzed.
 */
function createSpeedFactorConvertExpression(speedFactorValue) {
    // To be sure that the speed factor value expression is calculated properly, we need to add
    // the according parenthesis.
    return `450 / (${speedFactorValue})`;
}
exports.createSpeedFactorConvertExpression = createSpeedFactorConvertExpression;
//# sourceMappingURL=data:application/json;base64,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