/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Reference to a previously launched ripple element.
 */
export class RippleRef {
    constructor(_renderer, 
    /** Reference to the ripple HTML element. */
    element, 
    /** Ripple configuration used for the ripple. */
    config) {
        this._renderer = _renderer;
        this.element = element;
        this.config = config;
        /** Current state of the ripple. */
        this.state = 3 /* HIDDEN */;
    }
    /** Fades out the ripple element. */
    fadeOut() {
        this._renderer.fadeOutRipple(this);
    }
}
//# sourceMappingURL=data:application/json;base64,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