//------------------------------------------------------------------
//  testEventMgr.js
//  Copyright 2013 AppliedMinds, Inc.
//------------------------------------------------------------------

"use strict";
//------------------------------------------------------------------

testEventMgr();

/** Run all tests.
 */
function testEventMgr()
{
  console.log('testEventMgr starting.');

  testEventMgrAddFirst();
  testEventMgrAddSecond();
  testEventMgrAddMultiple();

  console.log('testEventMgr finished.');
}

/** Test adding an event, then a handler.
 */
function testEventMgrAddFirst()
{
  var container = testEventMgrCreateData();
  var view = container.view;
  var button = container.button;

  var mgr = new EventMgr();

  // Add an event then a handler.

  mgr.addEvent(button.clicked);
  mgr.addHandler("$parent.button", "clicked", view, "show");

  // Fire the event.

  testEventMgrAssert(!view.showCalled, 'showCalled before event.')

  button.clicked.sendEvent();  

  testEventMgrAssert(view.showCalled, 'showCalled after event.')
}

/** Test adding a handler, then an event.
 */
function testEventMgrAddSecond()
{
  var container = testEventMgrCreateData();
  var view = container.view;
  var button = container.button;

  var mgr = new EventMgr();

  // Add a handler then an event.

  mgr.addHandler("$parent.button", "clicked", view, "show");
  mgr.addEvent(button.clicked);

  // Fire the events.

  testEventMgrAssert(!view.showCalled, 'showCalled before event.')

  button.clicked.sendEvent();  

  testEventMgrAssert(view.showCalled, 'showCalled after event.')
}

/** Test adding multiple events and handlers.
 */
function testEventMgrAddMultiple()
{
  var container = testEventMgrCreateData();
  var view = container.view;
  var button = container.button;

  var mgr = new EventMgr();

  // Add events and handlers.

  mgr.addHandler("$parent.button", "clicked", view, "show");
  mgr.addHandler("$parent.view", "labelChanged", button, "setLabel");

  mgr.addEvent(button.clicked);
  mgr.addEvent(view.labelChanged);

  // Fire the event.

  testEventMgrAssert(!view.showCalled, 'showCalled before event.')

  button.clicked.sendEvent();  

  testEventMgrAssert(view.showCalled, 'showCalled after event.')
  testEventMgrAssert(mgr.pendingHandlers.length == 0, 'No pending handlers.')
}

/** Create a set of test data.
 */
function testEventMgrCreateData()
{
  // A button with a click event and a label.

  var button = {};
  button.clicked = new Event(button, "clicked", 0);
  button.label = "not set yet";
  button.setLabel = function(label)
  {
    this.label = label;
  }

  // A view with a label changed event and a handler.

  var view = {};
  view.labelChanged = new Event(view, "labelChanged", 1);
  view.showCalled = false;
  view.show = function()
  {
    this.showCalled = true;
  }

  // Scope tree.

  var container = {};
  container.button = button;
  container.view = view;
  button.$parent = container;
  view.$parent = container;

  return container;
}

/** A simple test assert.
 */
function testEventMgrAssert(condition, msg)
{
  if (!condition)
  {
    console.log("FAILED: " + msg);
  }
}

// END class testEventMgr
