//------------------------------------------------------------------
//  ErrorDialog.js
//  Copyright 2014 Applied Invention, LLC.
//------------------------------------------------------------------

"use strict";
//------------------------------------------------------------------

/** A simple dialog for displaying an error message.
 */

//------------------------------------------------------------------
// HTML attributes.
var errorDialogHtmlAttrs =
{
  /** DESCRIPTION OF ATTRIBUTE HERE.
   */
  //'sampleAttribute' : '=',
};

//------------------------------------------------------------------

/** Controller for the ErrorDialog directive.
 */
function ErrorDialogCtrl(ngScope)
{
  //----------------------------------------------------------------
  // Properties
  //----------------------------------------------------------------

  /** The title to display.
   */
  ngScope.title = "not set yet";

  /** The message to display.
   */
  ngScope.message = "not set yet";

  //----------------------------------------------------------------
  // Initialization
  //----------------------------------------------------------------

  /** Initializes a new ErrorDialogCtrl object.
   */
  ngScope.initErrorDialogCtrl = function()
  {
  };

  //----------------------------------------------------------------
  // Methods
  //----------------------------------------------------------------

  /** Called when this dialog has been opened.
   */
  ngScope.open = function(title, message)
  {
    ngScope.title = title;
    ngScope.message = message;

    ngScope.openDialog();
  };

  //----------------------------------------------------------------
  // Call the init method to initialize the new object.
  // Do not edit this line.
  ngScope.initErrorDialogCtrl();
  //----------------------------------------------------------------

} // END class ErrorDialogCtrl

ErrorDialogCtrl.$inject = ['$scope'];

//------------------------------------------------------------------
// Directive post-link function.
function errorDialogPostLink(/*ngScope, ngElement, ngAttrs*/)
{
}

//------------------------------------------------------------------
// Configuration of the errorDialog directive.
var errorDialogDirective =
{
  'restrict' : 'E',
  'transclude' : true,
  'scope' : errorDialogHtmlAttrs,
  'controller' : ErrorDialogCtrl,
  'templateUrl' : 'htmllib/dialogs/ErrorDialog.html',
  'replace' : true,
  'link' : errorDialogPostLink
};

//------------------------------------------------------------------
// Create the directive.
axeModule.directive('errorDialog',
                          axe.func.returns(errorDialogDirective));
