//------------------------------------------------------------------
//  TestFunc.ts
//  Copyright 2016 Applied Invention, LLC.
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeFunc from "../../util/func";
import * as axeString from "../../util/string";
import { UnitTest } from "../../unittest/UnitTest";
import { UnitTestRunner } from "../../unittest/UnitTestRunner";
//------------------------------------------------------------------

/** Unit test for the Func class.
 */
export class TestFunc extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new Func object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /* Test creating a getter function.
   */
  testGetter() : void
  {
    // Test object.

    let obj = {
      'foo': 3
    };

    let func = axeFunc.getter<number>('foo');
    let actual: number = func(obj);

    this.assertEqual('getter', 3, actual);
  }

  /* Test creating a setter function.
   */
  testSetter() : void
  {
    // Test object.

    let obj = {
      'foo': 2
    };

    // Test setting the value in the function call.

    let func = axeFunc.setter<number>('foo');

    func(obj, 3);

    this.assertEqual('after setter 1', 3, obj.foo);

    // Test setting a constant value in the setter func itself.

    func = axeFunc.setter('foo', 4);

    func(obj);

    this.assertEqual('after setter 2', 4, obj.foo);
  }

  /* Test creating a caller function.
   */
  testFuncCaller() : void
  {
    // An object with a target value that we'll manipulate.

    let globalTargetValue = 1;

    class IntValue
    {
      targetValue: number = 1;

      incrementTarget() : void
      {
        globalTargetValue += 1;
        this.targetValue += 1;
      }

      addToTarget(value: number) : void
      {
        globalTargetValue += value;
        this.targetValue += value;
      }
    }

    let obj = new IntValue();

    // Create a caller function that doesn't use arguments.

    let func = axeFunc.caller('incrementTarget');

    this.assertEqual('targetValue', 1, obj.targetValue);
    this.assertEqual('globalTargetValue', 1, globalTargetValue);

    func(obj);

    this.assertEqual('targetValue after', 2, obj.targetValue);
    this.assertEqual('globalTargetValue after', 2, globalTargetValue);

    // Create a caller function that passes an argument.

    func = axeFunc.caller('addToTarget', 100);

    func(obj);

    this.assertEqual('targetValue after add', 102, obj.targetValue);
    this.assertEqual('globalTargetValue after add', 102, globalTargetValue);

    // Create a caller function that passes an argument.

    func = axeFunc.caller('addToTarget');

    func(obj, -100);

    this.assertEqual('targetValue after func add', 2, obj.targetValue);
    this.assertEqual('globalTargetValue after func add', 2, globalTargetValue);
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestFunc

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestFunc());
