//------------------------------------------------------------------
//  JsonType.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../util/string";
import { JsonTypeError } from './JsonTypeError';
//------------------------------------------------------------------

/** The type of a ClassJson class field.
 */
export abstract class JsonType
{
  //----------------------------------------------------------------
  // Properties
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonType object.
   */
  constructor()
  {
  }

  //------------------------------------------------------------------
  // Methods
  //------------------------------------------------------------------

  /** Checks that the specified value can be converted to JSON.
   *
   * @param value The value to validate.
   *
   * @return None if the value is OK, or a JsonTypeError if there is a problem.
   */
  abstract validate(value: any) : JsonTypeError;

  /** Checks that the specified JSON string can be converted to an object.
   *
   * @param value The JSON value to validate.
   *
   * @return None if the value is OK, or a JsonTypeError if there is a problem.
   */
  abstract validateJson(value: any) : JsonTypeError;

  /** Encodes a value into JSON-ready value.
   */
  abstract encode(value: any) : any;

  /** Decodes a value from a JSON-ready value.
   */
  abstract decode(value: any) : any;

  /** Decodes any links in a JSON-ready value.
   */
  abstract decodeLinks(parents: Array<object>, value: object) : object;

  /** Returns a string representation of this object.
   */
  toString() : string
  {
    let propertyNames: Array<string> = [
    ];
    return axeString.formatObject("JsonType", this, propertyNames);
  }

} // END class JsonType
